# Vibe Coding 对话工程技巧

> 迭代式对话的艺术



你好，我是鱼皮。

在上一篇文章里，我们讲了 Vibe Coding 的 5 个核心心法。今天我们要深入探讨其中最关键的一个技能 —— 如何和 AI 进行高效对话。

很多同学在用 AI 的时候，会把它当成一个魔法按钮：输入一句话，期待它直接给出完美答案。

但现实往往是，AI 给出的结果要么不对，要么不够好。这时候，大家就会抱怨：AI 太笨了，根本不懂我的意思，是不是你这个 AI 能力不行啊？

其实，问题不在于 AI 笨，而在于我们没有掌握和它对话的技巧。今天，我就来教你如何通过 **对话工程**，让 AI 真正听懂你的需求。



## 一、对话工程和提示词工程？

很多朋友把和 AI 交流称为 “写提示词”、或者 “提示词工程”，我之前也是这样的。但如今，随着 AI 对模糊指令的理解能力越来越强，我觉得这个说法其实不够全面，因为它暗示了一种单向的、一次性的交流方式 —— 你写一个完美的提示词，AI 给你一个完美的答案。

但实际上，Vibe Coding 更像是一场对话。你和 AI 是在一起工作、一起探索、一起完善想法。这个过程是 **双向的、迭代的**。

举个例子，传统的 **提示词思维** 是这样的：

“请帮我用 React 和 Tailwind CSS 写一个响应式的导航栏，包含 Logo、菜单项（首页、关于、联系）、搜索框和用户头像，要支持移动端折叠菜单，颜色是深蓝色背景白色文字，Logo 在左边，菜单在中间，用户信息在右边……”

你想要在一句话里把所有需求都说清楚。但往往会遗漏一些细节，或者说得不够准确。

而 **对话思维** 是这样的：

你：我想做一个导航栏，你能帮我吗？

AI：当然可以。你想用什么技术栈？有什么设计要求吗？

你：我用 React 和 Tailwind CSS。设计上希望简洁专业，深蓝色背景。

AI：好的。导航栏需要包含哪些元素？

你：Logo、几个菜单项、搜索框和用户头像。

AI：明白了。需要支持移动端吗？

你：对，移动端要能折叠成汉堡菜单。

看到区别了吗？

对话思维让你可以逐步明确需求，而不是一开始就要想清楚所有细节。这样更自然，也更容易得到好结果。

![](https://pic.yupi.icu/1/promptvschat%E5%A4%A7.jpeg)




### 对话的好处

使用对话思维有几个明显的好处：

1. 降低认知负担：你不需要一次性想清楚所有细节，可以边聊边想。

2. 更容易发现问题：AI 的提问会帮你发现自己遗漏的地方。

3. 结果更准确：通过多轮交流，AI 能更准确地理解你的需求。

4. 学习效果更好：在对话过程中，你会学到很多新知识和最佳实践。



## 二、迭代式对话的核心技巧

下面分享几个最重要的对话技巧。



### 技巧一：从大到小，逐步细化

不要一开始就陷入细节。先从整体开始，然后逐步细化。

比如你想做一个博客系统，不要一上来就说：帮我写一个支持 Markdown、代码高亮、评论、点赞、分类、标签、搜索、RSS 订阅的博客系统。

而是这样开始：

1. 我想做一个简单的博客系统，用户能发布和查看文章
2. 文章需要支持 Markdown 格式
3. 能不能加上代码高亮功能
4. 我还想要一个简单的评论功能

每一步都很小，很容易理解和实现。这样 AI 就不会被复杂的需求搞晕，你也能随时调整方向。



### 技巧二：具体而非抽象

AI 不擅长理解抽象的概念，但很擅长处理具体的描述。

❌ 不好的例子：做一个好看的按钮

✅ 好的例子：做一个圆角按钮，蓝色背景（#3B82F6），白色文字，padding 上下 12px 左右 24px，鼠标悬停时背景变深蓝色（#2563EB）。

❌ 不好的例子：加一个用户友好的错误提示

✅ 好的例子：当用户输入的邮箱格式不对时，在输入框下方显示红色文字 "请输入有效的邮箱地址"。

描述越具体，AI 就越能准确地实现你的需求。




### 技巧三：提供参考和示例

你可以通过文字描述或者图片举例来帮助 AI 理解需求。

用文字描述，你可以这样说：

- 我想要一个类似 GitHub 的个人主页布局：左边是用户信息卡片，右边是活动时间线。
- 按钮的样式参考 Stripe 的设计：简洁、现代、有微妙的阴影。
- 表单验证的提示方式参考 Airbnb：实时验证，错误提示在输入框下方。

AI 见过很多网站和应用，你提供的参考能帮它快速理解你想要什么。

更直接的方法是用图片，现在的很多 AI 大模型（比如 Claude、GPT、Gemini）都支持图片理解，你可以：

- 截图你想要的设计效果，让 AI 照着做
- 截图出现的 bug 或错误，让 AI 看到具体问题
- 截图参考网站的布局，让 AI 模仿

比如下面这些提示词：

- 请参考这个截图的布局来设计我的页面：【上传截图】
- 我的页面在移动端显示不正常，看这个截图：【上传截图】，应该怎么修复？

一图胜千言，图片能让 AI 更准确地理解你的需求，特别是 UI 设计、网站开发和 Bug 修复时。



### 技巧四：分步骤提问

跟技巧 1 有点类似。对于复杂的功能，不要一次性要求 AI 全部完成。把它拆成多个步骤，一步一步来。

比如实现用户登录功能：

1. 先帮我创建一个登录表单，包含邮箱和密码输入框，还有一个登录按钮。
2. 现在给表单添加客户端验证：邮箱要符合格式，密码至少 6 位。
3. 当用户点击登录按钮时，发送 POST 请求到 /api/login，携带邮箱和密码。
4. 如果登录成功，跳转到首页；如果失败，显示错误信息。

每完成一步，你都可以测试一下，确保没问题再继续。这样即使出错，也容易定位问题。



### 技巧五：用提问来引导思考

有时候，你不确定该怎么做，可以让 AI 帮你分析。

- 我想在这里加一个缓存机制，但不确定用哪种方案。你能分析一下 Redis 和 Memcached 的优缺点吗？
- 这个页面加载有点慢，你觉得可能是什么原因？有什么优化建议？
- 我在考虑用 SSR 还是 CSR，你能帮我分析一下这两种方案在我这个项目中的适用性吗？

这样的提问能让 AI 发挥它的知识优势，帮你做出更好的决策。



## 三、如何描述清楚需求？

描述需求是对话中最重要的环节。描述得好，AI 就能做对；描述得不好，就会南辕北辙。



### 使用需求描述框架

在描述需求时，可以用一个系统化的框架来组织你的想法。这里推荐一个实用的框架：

**基础版（5要素）**：

1. 是什么（What）：要做什么功能或组件？
2. 为什么（Why）：这个功能的目的是什么？
3. 怎么做（How）：技术实现有什么要求？
4. 什么样（Style）：外观和交互有什么要求？
5. 什么情况（When/Where）：在什么场景下使用？

举个例子：

- 我需要一个搜索框（What）
- 让用户能快速找到文章（Why）
- 用 React 实现，输入时实时搜索（How）
- 样式要简洁，有搜索图标，输入框圆角（Style）
- 放在页面顶部导航栏的右侧（Where）

当然，不是每次都要说全五个要素，但建议至少要包含前三个。

**进阶版（6要素）**：

如果你想要更专业的输出，可以补充这个要素：

6）受众（Audience）：这个功能是给谁用的？他们的技术水平如何？

比如：“这个搜索功能是给普通用户用的，要简单易懂，不需要高级筛选。”

这样 AI 就能根据受众调整实现方案和交互设计。



### 说明技术背景

如果你想让 AI 帮你优化已有项目，那么 AI 需要知道你的项目用的是什么技术，才能给出合适的代码。

每次开始新对话时，建议先说明技术背景，比如：我的项目用的是 Next.js 15（App Router）、TypeScript、Tailwind CSS 和 Supabase。

如果有特殊的代码规范，也要说明，比如：我们的项目使用函数式组件，不用 class 组件。所有的 API 调用都用自定义的 useFetch hook。

这样 AI 生成的代码就能和你的项目保持一致。

虽然现在很多 AI 编程工具会引导 AI 先分析你已有的项目代码，但是人工明确技术栈可以让 AI 生成的内容更准确。

不过如果你不是一名程序员，或者不太懂这些技术，那么这一点就可以完全忽略掉了。这就是为什么在 AI 时代，我们仍然需要学习编程，因为懂技术的人更能引导和利用 AI。 




### 描述期望的输出

告诉 AI 你期望什么样的输出。比如：

- 请给我完整的组件代码，包括 TypeScript 类型定义
- 只给我核心逻辑，不需要样式代码
- 请给我一个可以直接运行的完整示例
- 请分步骤解释这段代码的工作原理

明确输出格式，能让 AI 更好地满足你的需求，否则 AI 可能会给你输出一大堆乱七八糟的内容。

我发现越强的 AI 就越容易把简单的需求搞复杂。像我之前就遇到过让 AI 生成一个小项目，结果它给我生成了 7 ~ 8 个文档，浪费了贼多 Token。




## 四、追问和纠偏的技巧

AI 第一次给出的答案往往不够完美。这时候，你需要通过追问和纠偏来改进结果。



### 追问的艺术

如果 AI 的回答不够详细，不要重新问一遍，而是追问细节。

❌ 不好的追问：再详细一点（太模糊）

✅ 好的追问：

- 你提到了使用 useEffect，能详细解释一下为什么要在这里用它吗？
- 这个函数的性能如何？处理大量数据时会有问题吗？
- 你选择用 Map 而不是 Object，是基于什么考虑？

具体的追问更能得到具体的答案。



### 让 AI 主动追问你

有时候，你可能不知道该提供哪些信息。这时候，可以让 AI 主动追问你：

```markdown
我想做【你的需求】。请你在回答前，先问我几个问题，了解更多细节，然后再给出方案。
```

这样 AI 会根据它的理解，问你一些关键问题，比如技术栈、使用场景、设计要求等。通过回答这些问题，你能把需求描述得更清楚，AI 也能给出更准确的方案。

这种方式特别适合你对需求还不够明确的时候，让 AI 帮你理清思路。



### 纠偏的方法

如果 AI 理解错了你的意思，要及时纠正。

- 不对，我想要的不是这样。我的意思是……
- 这个方案不太适合我的场景，因为……你能给我另一个方案吗？
- 你误解了我的需求。我要的是 A，不是 B。

不要不好意思纠正 AI，请尽情地骂它、羞辱它、甚至可以把它当做臭狗一样教训。它不会生气，反而会根据你的反馈给出更好的答案。



### 要求解释

如果你不理解 AI 给出的代码或方案，可以要求它解释。

- 这段代码是什么意思？能逐行解释一下吗？
- 为什么要这样写？有没有其他写法？
- 这个方案的优缺点是什么？

理解了原理，你才能真正掌握这些知识。




## 五、如何引导 AI 的输出？

有时候，AI 会给出一些不太理想的方案。这时候，你需要引导它往正确的方向走。




### 设定约束条件

通过设定约束，让 AI 在特定范围内思考。

- 请给我一个不依赖第三方库的纯 JavaScript 实现。
- 这个功能要在 100ms 内完成，请考虑性能优化。
- 代码要尽可能简洁，不超过 20 行
- 要考虑边界情况，比如空数组、null 值等

这些约束能让 AI 的输出更符合你的实际需求。




### 要求多个方案

不要满足于第 1 个方案，而是让 AI 给你多个选择。

- 请给我 3 种不同的实现方式，分别说明它们的优缺点。
- 这个问题有没有更简单的解决方案？
- 除了你刚才说的方法，还有其他方案吗？

多个方案能让你做出更明智的选择。

此外，鱼皮在做一个大项目时，会让多个不同的 AI 模型或 AI 产品同时给出方案，然后再人工进行挑选。这种方法适用于有一定专业知识的朋友。




### 使用角色扮演

让 AI 扮演特定角色，能得到更专业的建议。

- 请以一个资深前端工程师的角度，审查这段代码并给出改进建议。
- 假设你是一个 UX 设计师，这个交互流程有什么问题？
- 作为一个性能优化专家，你会如何改进这个页面的加载速度？

角色扮演能激发 AI 在特定领域的专业知识。

如果你不知道该让 AI 扮演什么角色，可以让 AI 自己选择最合适的专家：

```markdown
我想探讨【你的问题】。请你先选一位最适合的领域专家来思考它，可以是真实存在的名人或专家。然后以这个专家的视角来回答我的问题。
```

比如你想优化一个产品的用户体验，可以让 AI 选择合适的 UX 专家。AI 可能会选择某个知名的设计师或产品经理，然后以他们的视角给出建议。这样的回答往往更专业、更有深度。




## 六、对话模板库

为了提高效率，你可以准备一些常用的对话模板。

1）开始新功能的模板

```markdown
我要开发一个新功能：【功能描述】。我的技术栈是【技术栈】。请帮我：
1）分析这个功能的核心需求
2）建议一个合理的实现方案
3）列出可能遇到的问题
```

2）调试问题的模板

```markdown
我遇到了一个问题：【问题描述】。报错信息是：【错误信息】。相关代码是：【代码片段】。请帮我：
1）分析可能的原因
2）给出解决方案
3）解释为什么会出现这个问题
```

3）优化代码的模板

```markdown
这是我的代码：【代码片段】。它的功能是【功能说明】。请帮我：
1）找出可能的性能问题
2）改进代码的可读性
3）指出潜在的 bug
```

4）学习新知识的模板

```markdown
我想学习【技术/概念】。请：
1）用简单的语言解释它是什么
2）给我一个实际的使用例子
3）告诉我什么时候应该用它
```

这些模板可以帮你快速开始对话，节省时间。

更多的 AI 提示词模板可以在鱼皮的 [AI 资源导航网站](https://ai.codefather.cn/prompt) 获取：

![](https://pic.yupi.icu/1/image-20260104174539349.png)



## 七、常见的对话陷阱

在和 AI 对话时，有一些常见的错误要避免。



### 陷阱 1、一次问太多

不要在一个提问里塞进太多内容。

❌ 不好的例子：帮我实现用户注册、登录、密码重置、邮箱验证、权限管理、个人资料编辑功能。

这样 AI 会不知道从哪里开始，或者给你一个大而全但不够深入的答案。

正确做法：一次只问一个功能，做完一个再做下一个。



### 陷阱 2、不要假设 AI 有记忆

AI 的记忆是有限的。不要假设它记得很久之前说过的话。

如果你不确定 AI 的记忆容量是否足够，还想引用之前的内容，最好重新说明一遍：还记得我们之前做的登录表单吗？现在我想在它的基础上……

或者直接把相关代码贴出来：这是我们之前写的登录表单代码：【代码】。现在我想……

不过很多 AI 编程工具会显示当前记忆容量，能帮你把控：

![](https://pic.yupi.icu/1/image-20260104174741309.png)



### 陷阱 3、不要不测试就继续

每次 AI 给你代码后，一定要测试！不要不测试就继续要求下一个功能。

如果代码有问题，及时反馈给 AI。不要等到做了很多功能后才发现基础部分有问题。



### 陷阱 4、过度依赖

不要什么都问 AI。有些简单的问题，自己查文档、搜索或者使用其他工具可能更快。

AI 适合用来：
- 生成代码框架
- 解决复杂问题
- 学习新概念
- 审查和优化代码

不适合用来：
- 查询 API 文档
- 找简单的语法错误
- 做简单的计算（不如用计算器）

当然，不是说 AI 不能做这些，还是具体场景具体分析吧~



## 八、实战案例：完整的对话流程

让我用一个真实的例子，展示一次完整的、推荐的对话流程。

假设你要做一个待办事项应用的 “添加任务” 功能。



### 第一轮：明确需求

你："我想在我的待办事项应用里添加一个新建任务的功能。"

AI："好的。你想用什么方式让用户添加任务？是一个表单、一个输入框，还是其他方式？"

你："就一个简单的输入框，用户输入任务内容后按回车就添加。"

AI："明白了。任务除了内容，还需要其他信息吗？比如截止日期、优先级等？"

你："MVP 版本先不要这些，只要任务内容就行。"



### 第二轮：技术实现

你："我用的是 React 和 TypeScript。请帮我写这个输入框组件。"

AI：【给出代码】

你："看起来不错。但是我希望输入框在页面顶部，占满宽度，有一个淡蓝色的边框。"

AI：【给出改进的代码】



### 第三轮：添加功能

你："现在当用户按回车时，要把任务添加到任务列表里。我的任务列表是用 useState 管理的。"

AI：【给出添加任务的逻辑】

你："很好。但是如果输入框是空的，不应该添加任务。"

AI：【添加验证逻辑】



### 第四轮：优化体验

你："添加任务后，输入框应该自动清空并保持焦点，这样用户可以连续添加多个任务。"

AI：【添加清空和聚焦逻辑】

你："完美！最后，能不能在添加任务时显示一个简短的成功提示？"

AI：【添加提示功能】



---



看到了吗？通过多轮对话，我们逐步完善了这个功能。每一步都很小，很容易理解和测试。



## 九、深入学习提示词工程

如果你想更深入地学习提示词技巧，这里推荐一些资源。



### 学习 Cursor 的提示词设计

Cursor 作为最流行的 AI 编程工具之一，它的提示词设计非常值得学习。Cursor 的系统提示词长达 500 多行，包含了角色定义、操作约束、工具使用等多个模块，体现了很多提示词工程的最佳实践。

比如：
- 通过反复强调来确保 AI 理解重点
- 使用负面指令（NEVER）和正面指令（ALWAYS）来强化约束
- 为每个工具提供详细的说明和使用示例
- 统一输出格式便于后续处理

鱼皮专门录制了一期视频，详细拆解了 Cursor 的提示词设计：[《扒了下 Cursor 的提示词，被狠狠惊艳到了！》](https://www.bilibili.com/video/BV1bBaBzXEae/)

如果你对提示词工程感兴趣，或者想开发自己的 AI 应用，强烈推荐观看这个视频。



### 其他学习资源

- [阿里云百炼 Prompt 指南](https://help.aliyun.com/zh/model-studio/prompt-engineering-guide)：系统化的提示词编写教程
- [鱼皮的 AI 资源导航](https://ai.codefather.cn/prompt)：精选的提示词模板库
- [鱼皮的 AI 知识库](https://github.com/liyupi/ai-guide)：开源的 AI 学习资源



## 写在最后

对话工程是 Vibe Coding 中最重要的技能之一。它不是简单地 “写提示词”，而是一个持续的、双向的、迭代的交流过程。

让我总结一下要点：

1. 用对话思维代替提示词思维：把和 AI 的交流看作一场合作，而不是下命令。

2. 从大到小，逐步细化：先确定整体方向，再深入细节。

3. 具体而非抽象：用清晰、具体的语言描述你的需求。

4. 善用追问和纠偏：不要满足于第一个答案，通过追问让它更完善。

5. 引导而非命令：通过约束、角色扮演等方式引导 AI 给出更好的答案。

6. 避免常见陷阱：不要一次问太多，不要假设 AI 有完美记忆。

掌握了这些技巧，你就能和 AI 进行高效的对话，让它真正成为你的得力助手。

下一篇文章，我会讲解 **上下文工程**，教你如何管理项目信息，让 AI 始终理解你的项目。

加油，未来的 Vibe Coding 大师！💪



## 推荐资源

1）鱼皮 AI 导航网站：[AI 资源大全、最新 AI 资讯、免费 AI 教程](https://ai.codefather.cn)

2）编程导航学习圈：[学习路线、编程教程、实战项目、求职宝典、交流答疑](https://www.codefather.cn)

3）程序员面试八股文：[实习/校招/社招高频考点、企业真题解析](https://www.mianshiya.com)

4）程序员写简历神器：[专业模板、丰富例句、直通面试](https://www.laoyujianli.com)

5）1 对 1 模拟面试：[实习/校招/社招面试拿 Offer 必备](https://ai.mianshiya.com)
